﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;  
using System.Text;
using System.Collections;
using System.Linq.Dynamic;
using VeteransAffairs.Registries.Business;
using System.Data.Linq;
using VeteransAffairs.Registries.BusinessManager.Utilities; 



namespace VeteransAffairs.Registries.BusinessManager
{
    public enum EfrReferralStatus
    {
        None = 0,
        New = 4,
        Open = 5,
        Closed = 6,
        WaitingForInfo = 7,
        Duplicate = 8,
        Ineligible = 9,
        NoActionRequired = 10
    }
  
    public class ReferralManager:BaseBO 
    {
        public ReferralManager() 
        {
            _defaultSortField = "REFERRAL_ID desc";
            
        }

        
        private IQueryable<EFR_REFERRAL> LinqAll()
        {
            //populate LinqAll
            IQueryable<EFR_REFERRAL> tempLinq = (from e in _db.REFERRALs.OfType<EFR_REFERRAL>()
                                                select e);

            //TODO - add all business filtering rules 




            return tempLinq;
             
        }

        private void SetLoadWith(RegistriesDataAccess db)
        {
            
            DataLoadOptions lo = new DataLoadOptions();
            //patient needed here 
            lo.LoadWith<EFR_REFERRAL>(e => e.PATIENT);
            lo.LoadWith<PATIENT>(e => e.VTA_PATIENTs);
            lo.LoadWith<EFR_REFERRAL>(e => e.STD_INSTITUTION);
            //referral status needed here
            lo.LoadWith<EFR_REFERRAL>(e => e.STD_REFERRALST);
            lo.LoadWith<EFR_REFERRAL>(e => e.STD_REMINDERCLASS);
            lo.LoadWith<STD_INSTITUTION>(e => e.STD_INSTITUTION_PARENT);
            lo.LoadWith<EFR_REFERRAL>(e => e.REFERRAL_DETAILs);
            lo.LoadWith<EFR_REFERRAL>(e => e.WKF_CASEs);
            lo.LoadWith<WKF_CASE>(e => e.TBI_TRACKINGs);
            lo.LoadWith<WKF_CASE>(e => e.WKF_CASE_ACTIVITies);
            lo.LoadWith<WKF_CASE>(e => e.STD_WKFCASETYPE);
            lo.LoadWith<WKF_CASE>(e => e.STD_WKFCASEST);


            lo.LoadWith<REFERRAL_DETAIL>(e => e.STD_HEALTHFACTOR);  

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }


        private void SetPatientWorkflowsLoadWith(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();

            lo.LoadWith<EFR_REFERRAL>(e => e.PATIENT);
            lo.LoadWith<EFR_REFERRAL>(e => e.CONTACT_LOGs);

        }
        public IEnumerable<EFR_REFERRAL> Select(string sort, int startRow, int maxRows)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;

            }

            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                List<EFR_REFERRAL> entities;
                entities = SelectLinqFilter().OrderBy(sort).Skip(startRow).Take(maxRows).ToList();

                return entities;

            }
        }

        public int SelectCount(string sort, int startRow, int maxRows)
        {
            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                return SelectLinqFilter().Count();
            }
        }

        private IQueryable<EFR_REFERRAL> SelectLinqFilter()
        {
            IQueryable<EFR_REFERRAL> linqFilter = LinqAll();
            return linqFilter;
        }

        public STD_REFERRALST getReferralStatusByReferralID(int id) 
        {
            STD_REFERRALST entity;
            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                //entity = (from rst in _db.STD_REFERRALSTs join refs in _db.REFERRALs.Where( r => r.REFERRAL_ID == id ).OfType<EFR_REFERRAL>()  on rst.ID equals refs.STD_REFERRALSTS_ID select rst).SingleOrDefault();
                entity = (from rst in _db.STD_REFERRALSTs join refs in _db.REFERRALs.Where(r => r.REFERRAL_ID == id).OfType<EFR_REFERRAL>() on rst.ID equals refs.STD_REFERRALSTS_ID select rst).SingleOrDefault();   
            }

            return entity;
        }

        

        public EFR_REFERRAL getReferralByReferralID(int id)
        {
            EFR_REFERRAL entity;
            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                entity = (from refr in _db.REFERRALs.OfType<EFR_REFERRAL>() where refr.REFERRAL_ID == id select refr).FirstOrDefault();
            }

            return entity;
        }

        public PATIENT GetPatientByReferralId(int id)
        {
            PATIENT patient;
            using (_db = GetDataContext())
            {
                patient = (from refs in _db.REFERRALs.OfType<EFR_REFERRAL>() where refs.REFERRAL_ID == id select refs.PATIENT).FirstOrDefault();  
            }

            return patient;

        }

        /// <summary>
        /// Get patient by either referral ID or patient ID
        /// </summary>
        /// <param name="referralId"></param>
        /// <param name="patientId"></param>
        /// <returns></returns>
        public PATIENT GetPatient(int referralId, int patientId)
        {
            PATIENT patient = null;
            using (_db = GetDataContext())
            {
                if (referralId > 0)
                {
                    patient = (from refs in _db.REFERRALs.OfType<EFR_REFERRAL>() 
                               where refs.REFERRAL_ID == referralId 
                               select refs.PATIENT).FirstOrDefault();
                }
                else if (patientId > 0)
                {
                    patient = (from p in _db.PATIENTs
                               where p.PATIENT_ID == patientId
                               select p).FirstOrDefault();
                }
            }

            return patient;

        }

        public bool IraqAfghanServiceHealthFactorExists(int patientId)
        {
            bool exists = false;

            using (_db = GetDataContext())
            {
                vwEFRPatientOEFOIFHealthFactor healthFactor = (from e in _db.vwEFRPatientOEFOIFHealthFactors
                                                               where e.PATIENT_ID == patientId
                                                               select e).FirstOrDefault();
                exists = (healthFactor != null);
            }

            return exists;
        }

        public STD_REFERRALST GetNameByStatusId(int id)
        {
            STD_REFERRALST rst;
            using (_db = GetDataContext())
            {

                rst = (from st in _db.STD_REFERRALSTs where st.ID == id select st).FirstOrDefault();   

            }

            return rst;
        }

        public InstitutionGetByReferralResult GetInstitutionByReferralId(int id)
        {
            InstitutionGetByReferralResult result;
            using (_db = GetDataContext())
            {
             result = (from refs in _db.REFERRALs.OfType<EFR_REFERRAL>() 
                 let state = _db.STD_STATEs.Where(s => s.ID == refs.STD_INSTITUTION.STREETSTATE_ID && refs.REFERRAL_ID == id).SingleOrDefault().POSTALNAME
                 let country = _db.STD_COUNTRies.Where(c => c.ID == refs.STD_INSTITUTION.STREETCOUNTRY_ID && refs.REFERRAL_ID == id).SingleOrDefault().SHORTNAME  
                 where refs.REFERRAL_ID == id select new InstitutionGetByReferralResult
                { 
                  InstitutionAddress1 = refs.STD_INSTITUTION.STREETADDRESSLINE1,
                  InstitutionAddress2 = refs.STD_INSTITUTION.STREETADDRESSLINE2,
                  InstitutionCity = refs.STD_INSTITUTION.STREETCITY,
                  InstitutionPostal = refs.STD_INSTITUTION.STREETPOSTALCODE,
                  InstitutionName = refs.STD_INSTITUTION.NAME, 
                  InstitutionCountry = country,
                  InstitutionState = state   
                }).SingleOrDefault() ;  
            }

            return result;
        }

        public List<string> GetHealthfactorsByReferralId(int id)
        {
            List<string> factors;
            using (_db = GetDataContext())
            {
                factors = getReferralByReferralID(id).ToEntityTree().OfType<STD_HEALTHFACTOR>().Select(shf => shf.NAME).ToList();    

            }
            return factors;
        }

        

        

        public List<WKF_CASE_ACTIVITY> GetCommentsByReferralId(int id)
        {
            List<WKF_CASE_ACTIVITY> comments;
            using (_db = GetDataContext())
            {
                comments = getReferralByReferralID(id).WKF_CASEs.SelectMany(wfc => wfc.WKF_CASE_ACTIVITies).ToList();         

            }

            return comments;

        }

        //public INSTITUTION_CONTACT GetInstitutionContactByReferralId(int id)
        //{
        //    INSTITUTION_CONTACT contact;

        //    using (_db = GetDataContext())
        //    {
        //        contact = (from refs in _db.REFERRALs.OfType<REFERRAL>().Where( r => r.REFERRAL_ID == id )
        //         join cont in _db.INSTITUTION_CONTACTs
        //         on  refs.STD_INSTITUTION_ID equals cont.STD_INSTITUTION_ID select cont).SingleOrDefault();   
        //    }

        //    return contact; 
        //}
        private IQueryable<EFR_REFERRAL> SelectByStatusLinqFilter(string value, int id)
        {
            IQueryable<EFR_REFERRAL> linqFilter = LinqAll();

            if (id == 6)
            {
                int[] stats = { 6, 10 };

                linqFilter = from t in linqFilter where stats.Contains(t.STD_REFERRALSTS_ID) select t;
            }
            else
            {
                linqFilter = from t in linqFilter where t.STD_REFERRALSTS_ID == id select t;
            }
            
            
            string fieldSearch = "LAST_NAME";
               
            var param = Expression.Parameter(typeof(EFR_REFERRAL), "PATIENT");
            
            var name = Expression.PropertyOrField(Expression.PropertyOrField(param, "PATIENT"), fieldSearch);
            var search = Expression.Constant(value, typeof(string));

            var body = Expression.Call(name, "Contains", null, search);

            Expression<Func<EFR_REFERRAL, bool>> lambda;
            if (String.IsNullOrEmpty(value))
            {
                lambda = x => true;
            }
            else
            {
                lambda = Expression.Lambda<Func<EFR_REFERRAL, bool>>(body, param);
            }


            //linqFilter = linqFilter.OfType<PATIENT>().Where(lambda).SelectMany( t => t.REFERRALs.OfType<EFR_REFERRAL>() )  ; 
            //var query = (from p in _db.PATIENTs select p).Where(lambda);

            
            //linqFilter = from e in linqFilter join w in _db.PATIENTs.Where(lambda) on e.PATIENT_ID equals w.PATIENT_ID select e;    
            
                       
            return linqFilter.Where(lambda) ; 
              
        }

        public IEnumerable<ReferralsGetListByStatusResult> SelectByStatus(string searchValue, int id, string sort, int maxRows, int startRow)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;
            }
            using (_db = GetDataContext())
            {

                SetLoadWith(_db);
                IEnumerable<EFR_REFERRAL> entities;
                //entities = SelectByStatusLinqFilter(id).OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
                
                entities = SelectByStatusLinqFilter(searchValue, id).OrderBy(sort).Skip(startRow).Take(maxRows);

                return entities.Select(e => new ReferralsGetListByStatusResult
                {
                    ReferralId = e.REFERRAL_ID,
                    PatientName = e.PATIENT.LAST_NAME + ", " + e.PATIENT.FIRST_NAME + " " + e.PATIENT.MIDDLE_NAME,
                    ReferralDate = String.Format("{0:d}", e.REFERRAL_DATE),
                    ReferralStatus = e.STD_REFERRALST.NAME,
                    StationNumber = e.STD_INSTITUTION.STATIONNUMBER,
                    InstitutionName = e.STD_INSTITUTION.NAME

                }).ToList(); 
                //var results = new List<ReferralsGetListByStatusResult>();
                //foreach (var e in entities)
                //{
                //    results.Add(new ReferralsGetListByStatusResult(){
                        
                //        ReferralId = e.REFERRAL_ID,
                //        PatientName = e.PATIENT.LAST_NAME + ", " + e.PATIENT.FIRST_NAME + " " + e.PATIENT.MIDDLE_NAME,
                //        ReferralDate = String.Format("{0:d}", e.REFERRAL_DATE),
                //        ReferralStatus = e.STD_REFERRALST.NAME,
                //        StationNumber = e.STD_INSTITUTION.STATIONNUMBER,
                //        InstitutionName = e.STD_INSTITUTION.NAME
                                       
                //    });

                //}

                //return results; 
            }         
        }

        private IQueryable<EFR_REFERRAL> SelectByPatientIdLinqFilter(int id)
        {
            IQueryable<EFR_REFERRAL> linqFilter = LinqAll();

            linqFilter = from t in linqFilter where t.PATIENT_ID == id  select t;

            return linqFilter; 
        }

        public IEnumerable<ReferralsGetListByPatientResult> SelectByPatientId(int id)
        {
            using (_db = GetDataContext())
            {

                SetPatientWorkflowsLoadWith(_db);
                //IEnumerable<EFR_REFERRAL> entities;

                var entities = SelectByPatientIdLinqFilter(id);

                
                List<ReferralsGetListByPatientResult> patReferralList = entities.Select(e => new ReferralsGetListByPatientResult
                {
                    ReferralId = e.REFERRAL_ID,
                    ReferralStatusId = e.STD_REFERRALSTS_ID, 
                    ReferralStatus = e.STD_REFERRALST.NAME,
                    StationNumber = e.STD_INSTITUTION.STATIONNUMBER,
                    InstitutionName = e.STD_INSTITUTION.NAME,
                    ReferralWorkflowCount = e.WKF_CASEs.Count(),   
                    ContactLogsCount = e.CONTACT_LOGs.Count(),
                    ContactLogsFollowupCount = e.CONTACT_LOGs.Where( t => t.FOLLOWUP_REQUIRED_FLAG == true).Count(),
                    BioFollowUps = e.WKF_CASEs.SelectMany( o => o.WKF_CASE_ACTIVITies).Where( a => a.FOLLOWUP_REQUIRED_FLAG == true).ToList(),
                    PatientSSN = e.PATIENT.Snum,
                    PatientId = e.PATIENT.PATIENT_ID 
                }).ToList();

                //custom sorting by referral status then by referral id in descending order
                Func<ReferralsGetListByPatientResult, int> statusSelector = item =>
                {

                    if (item.ReferralStatusId == 5)
                    {
                        return 0;
                    }
                    else if (item.ReferralStatusId == 6)
                    {
                        return 1;
                    }
                    else if (item.ReferralStatusId == 4)
                    {
                        return 2;
                    }
                    else if (item.ReferralStatusId == 9)
                    {
                        return 3;
                    }
                    else
                    {
                        return 4;
                    }


                };
                List<ReferralsGetListByPatientResult> patReferralOrderedList = patReferralList.OrderBy(statusSelector, Comparer<int>.Default) 
                                                        .ThenByDescending(s => s.ReferralId).ToList(); 

                //int[] keys = new int[patReferrals.Length]; 

                //Dictionary<int, int> mapping = new Dictionary<int, int>(); 
                    
                //// set up our mappings for referral statuses like so
                        
                //mapping.Add( (int)ReferralStatus.InProcess, 0 ); 
                //mapping.Add( (int)ReferralStatus.Completed, 1 ); 
                //mapping.Add( (int)ReferralStatus.New, 2 ); 
                //mapping.Add( (int)ReferralStatus.Ineligible, 3 ); 
                
                //for(int i=0; i < keys.Length; i++) 
                //{
                //    int token = patReferrals[i].ReferralStatusId; 

                //    int mappingKey; 
                    
                //    if(!mapping.TryGetValue(token, out mappingKey)) 
                //         mappingKey = int.MaxValue;

                //    keys[i] = mappingKey;

                //}
                //Array.Sort(keys, patReferrals);
                  
                
                return patReferralOrderedList;

            }
        }

        //public int SelectByPatientIdCount(string searchValue, int id)
        //{
        //    using (_db = GetDataContext())
        //    {
        //        //SetLoadWith(_db);
        //        return SelectByPatientIdLinqFilter(id).Count();
        //    }
        //}

        public EFR_REFERRAL Update(EFR_REFERRAL referral)
        {
            using (_db = GetDataContext())
            {
                _db.DeferredLoadingEnabled = false;

                referral.SynchroniseWithDataContext(_db); //this line traverses all entities, attaching all of them as appropriate to the data context.

                try
                {
                  
                    _db.SubmitChanges(ConflictMode.ContinueOnConflict);

                    //create an instance of the custom eventArgs in order to populate the id selected
                    BOSaveSuccessEventArgs eventArgs = new BOSaveSuccessEventArgs();
                    eventArgs.SavedItemId = referral.REFERRAL_ID;

                    RaiseSaveEvent(this, eventArgs);

                }
                catch(ChangeConflictException) 
                {
                    _db.ChangeConflicts.ResolveAll(RefreshMode.KeepChanges);
                }

            }

            return referral; 
        }
       

        public int SelectByStatusCount(string searchValue, int id)
        {
            using (_db = GetDataContext())
            {
                //SetLoadWith(_db);
                return SelectByStatusLinqFilter(searchValue, id).Count();
            }
        }

        public int AutoTriageAcceptedReferrals()
        {
            using (_db = GetDataContext())
            {

                int? records = 0;
                _db.AutoTriageReferrals_Accept(ref records);

                return records.Value;
            }
        }

        public int AutoTriageDuplicates()
        {
            using (_db = GetDataContext())
            {

                int? records = 0;
                _db.AutoTriageReferrals_Duplicates(ref records);

                return records.Value;
            }
        }

        public int AutoTriageIneligibles()
        {
            using (_db = GetDataContext())
            {

                int? records = 0;
                _db.AutoTriageReferrals_Ineligible(ref records);

                return records.Value;
            }
        }

        public int AutoTriageReferralCount()
        {
            using (_db = GetDataContext())
            {
                return SelectLinqFilter().Where(s => s.STD_REFERRALSTS_ID == (int)ReferralStatus.New).Count();  

            }
        }
        public class ReferralsGetListByPatientResult
        {
            public int ReferralId { get; set; }
            public int ReferralStatusId { get; set; }
            public int ContactLogsCount { get; set; }
            public int ContactLogsFollowupCount { get; set; }
            public string ReferralStatus { get; set; }
            public int ReferralWorkflowCount { get; set; }
            public List<WKF_CASE_ACTIVITY> BioFollowUps { get; set; }
            public string StationNumber { get; set; }
            public string InstitutionName { get; set; }
            public string PatientSSN { get; set; }
            public int PatientId { get; set; }
        }
        public class ReferralsGetListByStatusResult
        {
            public int ReferralId { get; set; }
            public string PatientName { get; set; }
            public string ReferralDate { get; set; }
            public string ReferralStatus { get; set; }
            public string StationNumber { get; set; }
            public string InstitutionName { get; set; }

        }

        public class InstitutionGetByReferralResult
        {
            public string InstitutionName { get; set; }
            public string InstitutionAddress1 { get; set; }
            public string InstitutionAddress2 { get; set; }
            public string InstitutionCity { get; set; }
            public string InstitutionState { get; set; }
            public string InstitutionPostal { get; set; }
            public string InstitutionCountry { get; set; }
        }

        public class  InstitutionContactGetByReferralResult
        {
            public string ContactName { get; set; }
            public string ContactEMail { get; set; }
            public string ContactPhone { get; set; }
            public string ContactFax { get; set; }

        }

       
    }
}
